// usb configure.cpp : Defines the class behaviors for the application.
//
//(C) Copyright Dave Roberts G8KBB 2005
// This program is released only for the purpose of self training and eduation
// in amatuer radio. It may not be used for any commercial purpose, sold or
// modified.
// It has been written as an exercise in self tuition by me as part of my hobby
// and I make no claims about its fitness for purpose or correct operation.


#include "stdafx.h"
#include "usb configure.h"
#include "UsbConfigurePropertySheet.h"
#include "Communicate.h"
#include "Download.h"
#include "Program.h"
#include "Setup.h"
#include "common.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CCommunicate *pCCommunicate;
CDownload *pCDownload;
CProgram *pCProgram;
Setup *pCSetup;

//char    pcDriverName[MAX_DRIVER_NAME]   = "";
CString pcDriverName;
CString m_AxFilename;
CString m_ConfigFilename;
CString sMessage;
VNA_TXBUFFER_RAW RawMessage;
VNA_TXBUFFER_CMD SetMessage;
VNA_TXBUFFER_CMD9912 SetMessage9912;

/////////////////////////////////////////////////////////////////////////////
// CUsbconfigureApp

BEGIN_MESSAGE_MAP(CUsbconfigureApp, CWinApp)
	//{{AFX_MSG_MAP(CUsbconfigureApp)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CUsbconfigureApp construction

CUsbconfigureApp::CUsbconfigureApp()
{
	pCCommunicate = NULL;
	pCDownload = NULL;
	pCProgram = NULL;
	pCSetup = NULL;
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CUsbconfigureApp object

CUsbconfigureApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CUsbconfigureApp initialization

BOOL CUsbconfigureApp::InitInstance()
{
	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
//	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	// Set the first byte of each message type to the correct value
	// for that message. We never show this byte of the array to
	// them and offer no chance to change it

	RawMessage.command_code = 0x5A;
	RawMessage.flags = 0;
	RawMessage.portA = 0;
	RawMessage.portB = 0;
	RawMessage.attenuator = 0;
	SetMessage.command_code = 0x55;
	SetMessage9912.command_code = 0x56;

	// we have 4 main objects for the 4 tabs on the dialog box
	// create them and add them to the propertypage

	pCCommunicate = new CCommunicate;
	pCDownload = new CDownload;
	pCProgram = new CProgram;
	pCSetup = new Setup;

	m_pMainWnd = &dlg;

	dlg.AddPage(pCCommunicate);
	dlg.AddPage(pCDownload);
	dlg.AddPage(pCProgram);
	dlg.AddPage(pCSetup);

	// Setup registry access for configuration changes
	CString strCurr;
	strCurr.LoadString(IDS_STRINGRegKey);
	SetRegistryKey( strCurr );

	CString sSetup, sToken;
	sSetup.LoadString(IDS_STRING_SETUP);
	sToken.LoadString(IDS_VENDAX_FILENAME);
	m_AxFilename = AfxGetApp( )->GetProfileString( sSetup, sToken, "Vend_Ax.hex" );
	sToken.LoadString(IDS_DRIVER_FILENAME);
	pcDriverName = AfxGetApp( )->GetProfileString( sSetup, sToken, "ezusb-0" );
	sToken.LoadString(IDS_N2PK_CONFIG_NAME);
	m_ConfigFilename = AfxGetApp( )->GetProfileString( sSetup, sToken, "N2PK VNA" );

	sToken.LoadString(IDS_N2PK_CONFIG_9912);
	b_9912 = AfxGetApp( )->GetProfileInt( sSetup, sToken, 0 );

	sToken.LoadString(IDS_N2PK_CYUSB_INDEX);
	nCyUsbDevice = AfxGetApp( )->GetProfileInt( sSetup, sToken, 0 );
	sToken.LoadString(IDS_N2PK_CYUSB_N2PK_GUID);
	bUsingN2pkGUID = AfxGetApp( )->GetProfileInt( sSetup, sToken, false ) ? true : false;
	sToken.LoadString(IDS_N2PK_CYUSB_MSA_GUID);
	bUsingMsaGUID = AfxGetApp( )->GetProfileInt( sSetup, sToken, false ) ? true : false;
	sToken.LoadString(IDS_N2PK_USE_CYUSB);
	bUsingCyUSB = AfxGetApp( )->GetProfileInt( sSetup, sToken, false ) ? true : false;
	sToken.LoadString(IDS_N2PK_SUPPORT_9912);
	bSupport9912 = AfxGetApp( )->GetProfileInt( sSetup, sToken, false ) ? true : false;
	sToken.LoadString(IDS_N2PK_INTERFACE_TYPE);
	nInterfaceType = AfxGetApp( )->GetProfileInt( sSetup, sToken, false );

	if( bUsingCyUSB )
	{
		if( bUsingN2pkGUID )
			USBDevice = USBDeviceN2PK;
		else if( bUsingMsaGUID )
			USBDevice = USBDeviceMSA;
		else
			USBDevice = USBDeviceCyUSB;
	}

	// ToDo: make a pretty Icon.

    HICON Icon=LoadIcon(IDR_MAINFRAME);
    dlg.m_psh.dwFlags|=PSH_USEHICON;
    dlg.m_psh.hIcon=Icon;

	dlg.SetTitle("N2PK VNA USB Interface Control V2.3");

	// we create the tabbles dialog ox (PropertyPage) here. It is displayed
	// hen we return from this function to the framework

 	dlg.Create(NULL,WS_SYSMENU|WS_POPUP|WS_CAPTION|DS_MODALFRAME|WS_VISIBLE|WS_MINIMIZEBOX);

	// Changing the size of the dialog is obviously not appropriate !

    CMenu *pSysMenu = dlg.GetSystemMenu(FALSE);
    ASSERT(pSysMenu != NULL);
    VERIFY(pSysMenu->RemoveMenu(SC_MAXIMIZE, MF_BYCOMMAND)); 
    VERIFY(pSysMenu->RemoveMenu(SC_SIZE, MF_BYCOMMAND)); 

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// when we exit be nice and remove our mess

int CUsbconfigureApp::ExitInstance() 
{
	if( pCCommunicate != NULL )
		delete pCCommunicate;
	if( pCDownload != NULL )
		delete pCDownload;
	if( pCProgram != NULL )
		delete pCProgram;
	if( pCSetup != NULL )
		delete pCSetup;
	
	return CWinApp::ExitInstance();
}
